#!/bin/sh

if [ $# -ne 1 ] || ( [ $1 != "start" ] && [ $1 != "stop" ] ) ; then
  echo "usage. $0 start | stop"
  exit 255
fi

DIR=`dirname "${0}"`

start_test () {
  echo start ftp test
  # set ipaddress
  ifconfig eth0:1 192.168.101.29 netmask 255.255.252.0

  # set user password
  rm /etc/vsftpd/users.lst
  rm /etc/vsftpd/vsftpd-virtual-user.db

  # username A
  echo "A" > /etc/vsftpd/users.lst
  # password A
  echo "A" >> /etc/vsftpd/users.lst

  db_load -T -t hash -f /etc/vsftpd/users.lst /etc/vsftpd/vsftpd-virtual-user.db

  # start ftp server
  /etc/init.d/vsftpd start
}

stop_test () {
  echo stop ftp test
  # set ipaddress
  "${DIR}/change_ip.sh" "/opt/CSMRoot/Storage Card/LSR902/Setdata/Com/System.txt"

  # set user password
  "${DIR}/change_ftp_user.sh" "/opt/CSMRoot/Storage Card/LSR902/Setdata/Com/System.txt"

  # stop ftp server
  "${DIR}/change_ftpd_server_state.sh" "/opt/CSMRoot/Storage Card/LSR902/Setdata/Com/System.txt"
}

ROOTFS_RO=`"${DIR}/check_rootfs_ro.sh"`

# rootfs read write
if [ ${ROOTFS_RO} == "ro" ];then
  mount -o rw,remount /
fi

if [ $1 = "start" ]; then
  start_test
else
  stop_test
fi

# rootfs read only
if [ ${ROOTFS_RO} == "ro" ];then
  mount -o ro,remount /
fi

# success
exit 0
